/* USTEPCMD.H generated from USTEPCMD.4TH */


/* BASE:  */
/* Command acknowledge bytes  */
#define MCA_OK                     64 /* Operation succeeded, or unreported failure          */
#define MCA_FAIL                   65 /* Operation failed                                    */
/* Command acknowledge byte mask bits  */
#define MCAM_FAIL                   1 /* Bit 0  0=Command succeeded  1=Command failed        */
#define MCAM_HALT                   2 /* Bit 1  0=Moving             1=Halted                */
#define MCAM_ESTOP                  4 /* Bit 2  0=Ok                 1=Emergency stop        */
/* Command-specific acknowledge byte mask bits  */
#define MCAM_FIXFLAG               16 /* Bit 4  0=Home flag ok       1=Adjust home flag      */
#define MCAM_BUG                   32 /* Bit 5  0=Ok                 1=Internal error   */
/* Command bytes  */
#define MCC_DEGAUSS                69 /* Degauss any combo of x,y,z       mask8b             */
#define MDGM_X                      1 /*   Mask: Degauss X                                   */
#define MDGM_Y                      2 /*   Mask: Degauss Y                                   */
#define MDGM_Z                      4 /*   Mask: Degauss Z                                   */
#define MCC_HOME                   87 /* Table zero                       8b                 */
#define MHMM_Z                      1
#define MHMM_Y                      2
#define MHMM_R                      4
#define MHMM_X                      8
#define MCC_HOME1                 104 /* Single-axis home              a8b p8b d8b t32b f32b */
#define MCC_RAMPMODE              109 /* Enable/disable curve ramps       8b                 */
#define MCRM_SEGMENT                0
#define MCRM_CPATH                  1
#define MCC_STATUS                110 /* No operation, acknowlege                            */
#define MCC_NOP                   127 /* No operation, no acknowledge     --                 */
#define MCC_PARAM                 112 /* Set motion parameter             index16b val32b    */
#define MCC_PASSCHAR               99 /* Send character to diag port      8b                 */
#define MCC_PENDNWT               100 /* Pen down with Wait               --                 */
#define MCC_PENDOWN                68 /* Pen down                         --                 */
#define MCC_PENUPWT               117 /* Pen up with Wait                 --                 */
#define MCC_PENUP                  85 /* Pen up                           --                 */
/* ASCII e EQU MCC.SCANRES ( Set pen pulse divisor            8b                 */
#define MCC_SLAVE                 118 /* Enter Slave mode                 xunit16b yunit16b  */
#define MCC_SPEED                 115 /* Set line speed in units/sec      speed16b           */
#define MCC_SYNC                   78 /* Synchronize                      8b                 */
#define MCC_SYNCNB                105 /* Synchronize, no boot             8b                 */
/* ASCII F EQU MCC.VIEWFROM ( Come from view position         --                 */
/* ASCII V EQU MCC.VIEWTO  ( Go to view position              --                 */
#define MCC_WAIT                   71 /* Wait for motion to complete      --                 */
#define MCC_XREL                  120 /* X axis relative move             x32b               */
#define MCC_XYABS                  97 /* Absolute x/y move                x32b     y32b      */
#define MCC_XYMANUAL               77 /* X/Y non-ramping interactive move dir8b              */
#define MCC_XYREL                 114 /* Relative x/y move                x32b     y32b      */
#define MCC_XYREL8                 82 /* Relative Short x/y move          x8b      y8b       */
#define MCC_XYREL16                67 /* Relative short X/Y move          x16b     Y16b      */
#define MCC_XYSELECT              102 /* Select coordinated axes          xaxis8b  yaxis8b   */
#define MCC_XYZSELECT              80 /* Select 3D coordinated axes       x8b y8b z8b        */
#define MCC_XYZABS                 72 /* 3D coordinated move              x32b y32b z32b     */
#define MCC_XYZREL                 75 /* 3D coordinated relative move     x32b y32b z32b     */
#define MCC_XYZREL16               76 /* 3D coordinated rel short move    x16b y16b z16b     */
#define MCC_XABS                  124 /* X-axis absolute move             x32b               */
#define MCC_YABS                  108 /* Y-axis absolute move             y32b               */
#define MCC_YREL                  121 /* Y-axis relative move             y32b               */
#define MCC_YSELECT               119 /* Select logical Y axis            8b                 */
#define MCC_1ABS                  122 /* 1-axis absolute move             8b y32b            */
#define MCC_1REL                   90 /* 1-axis relative move             8b y32b            */
#define MCC_ZMANUAL                98 /* Z-axis interactive move          limit32b inc32b    */
#define MCC_YMANUAL                66 /* Selected Y axis interactive move limit32b inc32b    */
#define MCC_1SPEED                107 /* Set axis speed in units/sec      8b speed16b        */
#define MCC_RASTER                 65 /* Raster scan              0 x32b y32b n16 handshake  */
#define MCRT_NONE                   0 /* Not a raster scan                                   */
#define MCRT_1BIT                   1 /* Raster scan has 1-bit pixels                        */
#define MCRT_4BIT                   2 /* Raster scan has 4-bit pixels                        */
#define MCRT_8BIT                   3 /* Raster scan has 8-bit pixels                        */
#define MCR_ACKDIV                  8 /* Scan data bytes per ACK for MCC.RASTER              */
#define MCC_GETINFO                83 /* Get 32-bit status information    handshake seq      */
#define MCC_GETZ                   73 /* Get Z coordinate and status byte handshake seq      */
#define MCC_GETXY                  74 /* Get x,y coordinates              handshake seq      */
#define MCC_GETVER                106 /* Get USTEP version                handshake seq      */
#define MCC_GETENC                103 /* Obsolete.  Use MCC.GETINFO/MCG.ENCODER              */
#define MCC_NEXTBYTE               46 /* Send next data byte              --                 */
#define MCC_TESTMODE               84 /* Force pen down                   8b                 */
#define MCC_TRAIN                 116 /* Enter train mode                 --                 */
#define MCC_TRAINEND               71 /* An alias for MCC.WAIT            --                 */
#define MCC_EOF                    79 /* End-of-file in vending-machine mode                 */
#define MCC_ESTOP                  96 /* Emergency stop code 60h          "`````````"        */
#define MCC_RESERVED1             111
#define MCC_RESERVED2              88
#define MCC_RESERVED3              89
#define MCE_ESTOPDET               12 /* ESTOP detection length                              */
#define MCE_ESTOPLEN               16 /* Recommended ESTOP transmit length                   */
/* FBOOT commands  */
#define FBOOT_AUTO                 65 /* Enable autoboot                                     */
#define FBOOT_ERASE                69 /* Erase flash                                         */
#define FBOOT_NOAUTO               79 /* Disable autoboot                                    */
#define FBOOT_BOOT                 78 /* Boot flash, equal to MCC.SYNC                       */
#define FBOOT_DNL                  76 /* Boot DNL                                            */
#define FBOOT_QUERY                83 /* Get hw/firmware info.  A digit follows.             */
/* X/Y manual-motion direction byte  */
#define MCM_STOP                   48
#define MCM_N                      49
#define MCM_NE                     50
#define MCM_E                      51
#define MCM_SE                     52
#define MCM_S                      53
#define MCM_SW                     54
#define MCM_W                      55
#define MCM_NW                     56
/* Z-adjust command bytes  */
#define MCA_STATUS                 63 /* Continue moving. Return incremental #moves.     */
#define MCA_STOP                   48 /* Stop moving.     Return incremental #moves.     */
/* Terminate SLAVE mode  */
#define MCS_STOP                    0
/* Parameter values for MCC.HOME  Table zero  */
#define MCH_XRY                    48
#define MCH_ZXRY                   49
/* Definitions for MCC.GETINFO  Get status information  */
/* Status indexes  */
#define MCG_MOTOR                   0 /* Get per-motor status for subindex motor#      */
#define MGM_LOCK                    1 /*  Mask: Single Interlock input, motor# ignored */
#define MGM_DISABLED                2 /*  Mask: Motor driver is disabled               */
#define MGM_INDEX                   4 /*  Mask: Index input                            */
#define MGM_LIMIT                   8 /*  Mask: Limit input                            */
#define MCG_DACOFFSETS              1 /* Get the 2 DAC offsets for subindex motor#     */
#define MCG_POS                     2 /* Get axis position for subindex motor#         */
#define MCG_ENCODER                 3 /* Get encoder value for subindex encoder#       */
#define MCG_HWVERSION               4 /* Get hardware version from RABIO               */
#define MCG_SRAM                    5 /* Get 4 bytes at even address EPARAM1+subindex  */
#define MCG_DRAM                    6 /* Get 4 bytes at even offset  EPARAM1+subindex, page EPARAM2 */
#define MCG_FWVERSION               7 /* Get firmware version in high word options in low word  */
#define MCG_SAVED_ID                8 /* ID of the saved image from the last MCP.SAVE  */
#define MCG_INPUTS                  9 /* Get miscellaneous inputs                      */
#define MIM_XWIDX                1024 /* Index for X train wheel                       */
#define MIM_YWIDX                2048 /* Index for Y train wheel                       */
#define MIM_PHASE                4096 /* Drill phase                                   */
#define MCG_HWSERIAL               10 /* Hardware serial number                        */
#define MCG_CELCIUS                11 /* Chassis temperature                           */
#define MCG_EPARAM1                12 /* Extended parameter 1                          */
#define MCG_EPARAM2                13 /* Extended parameter 2                          */
#define MCG_FLAG_PHASE             14 /* Motor phase at flag from last HOME1 [obs.]    */
#define MCG_PARM_ID                15 /* ID of saved params from last MCP.SAVEPARMS    */
#define MCG_LASLOG_START           16 /* Laser log begin pointer                       */
#define MCG_LASLOG_STOP            17 /* Laser log end pointer                         */
#define MCG_FOREGROUND             18 /* Foreground CPU usage = hiword/loword          */
#define MCG_HOME_CHECK             19 /* Flag pos for subindex motor# at last HOME     */
#define MCG_AXIS_FLAG_PHASE        20 /* HOME flag phase for subindex motor#           */
#define MCG_BOOTFLAGS              21 /* Bit0 autoboot enable.  Other bits reserved.   */
#define MCG_RESISTANCE             22 /* Motor coil resistances. High 16b is odd coil  */
#define MCG_INDUCTANCE             23 /* Motor coil inductances. Low 16b is even coil  */
#define MCG_MUXIN                  24 /* Read 16 mux inputs, group# subindex           */
#define MGMIM_ERROR              32768 /* MUXIN high word flags mask                    */
#define MCG_RTPOS                  25 /* Real-time position val=X eprm1=Y eprm2=Z      */
#define MCG_STEPSIZE               26 /* HiWord=steps LoWord=mils for axis subindex    */
#define MCG_VUNIT                  27 /* Velocity unit in phase units                  */
#define MCG_ESTOP                  28 /* Read and clear Emergency Stop Flags           */ /* Masks:                                        */
#define MCGEM_ZIDX                  1 /* Z index Estop                                 */
#define MCGEM_YIDX                  2 /* Y index Estop                                 */
#define MCGEM_RIDX                  4 /* R index Estop                                 */
#define MCGEM_XIDX                  8 /* X index Estop                                 */
#define MCGEM_ZFLG                 16
#define MCGEM_YFLG                 32
#define MCGEM_RFLG                 64
#define MCGEM_XFLG                128
#define MCGEM_ILOCK               256 /* Interlock input Estop                         */
#define MCGEM_CMD                 512 /* MCC.ESTOP string                              */ /* Bit numbers:                                  */
#define MCGEB_ZIDX                  0 /* Z index Estop                                 */
#define MCGEB_YIDX                  1 /* Y index Estop                                 */
#define MCGEB_RIDX                  2 /* R index Estop                                 */
#define MCGEB_XIDX                  3 /* X index Estop                                 */
#define MCGEB_ZFLG                  4
#define MCGEB_YFLG                  5
#define MCGEB_RFLG                  6
#define MCGEB_XFLG                  7
#define MCGEB_ILOCK                 8 /* Interlock input Estop                         */
#define MCGEB_CMD                   9 /* MCC.ESTOP string                              */
#define MCGEB_CANCEL               10 /* Engraver panel CANCEL                         */
#define MCGEB_ABORT                11 /* Engraver panel ABORT                          */
#define MCG_DRAM_BYTES             29 /* Total size of DRAM                            */
#define MCG_RESERVED               30
#define MCG_MCGMAX                 30
/* Definitions for MCC.PARAM  Set motion parameters  */
/* Parameter indexes  */
#define MCP_MAKERAMPS               1 /* Regenerate the ramp tables                          */
#define MCP_DEFAULTS                2 /* Reset to default ramp parameters                    */
#define MCP_HOME                    3 /* Perform table zero                                  */
#define MCP_TEST                    4 /* Perform test routine                                */
#define MCT_PLOTVER                 1 /* Plot the USTEP ROM version number  */
#define MCT_LINES                   2
#define MCP_YROTOR                  5 /* Set Y position for rotary plotting                  */
#define MCP_DUMPRAMP                6 /* Dump ramp tables for ramp EPARAM1 to download port  */
/* 0007 EQU MCP.YAXIS    ( Assign physical axis MCI.xPHYS to logical Y axis    */
#define MCI_ZPHYS                   0 /* Z physical axis number  */
#define MCI_YPHYS                   1 /* Y physical axis number  */
#define MCI_RPHYS                   2 /* R physical axis number  */
#define MCI_XPHYS                   3 /* X physical axis number  */
#define MCI_LPHYS                   4 /* L physical axis number  */
#define MCP_EPARAM1                12 /* Extended parameter value 1                          */
#define MCP_XPARAM1                12 /* Extended parameter value 1 old name                 */
#define MCP_EPARAM2                13 /* Extended parameter value 2                          */
#define MCP_XPARAM2                13 /* Extended parameter value 2 old name                 */
#define MCP_SLOPE                  14 /* Set slope of ramp EPARAM1 at EPARAM2 milliseconds   */
#define MCP_START0                 15 /* Initial speed for slow lines for ramp EPARAM1       */
#define MCP_START1                 16 /* Initial speed for fast lines for ramp EPARAM1       */
/*    EPARAM1 values for MCP.SLOPE, MCP.START0, MCP.START1:                    */
#define MCI_ZRAMP                   0
#define MCI_YRAMP                   1
#define MCI_RRAMP                   2
#define MCI_XRAMP                   3
#define MCI_CRAMP                   4
#define MCI_NRAMPS                  5
#define MCI_CPAUTO                  5 /* For MCP.CPRAMP below                                */
#define MCI_CPOFF                4294967295 /* For MCP.CPRAMP below                                */
#define MCI_NSLOPES                 7
#define MCP_UNIT                   17 /* Plotter unit size            for axis EPARAM1       */ /* Valid plotter unit sizes are:                       */ /* 8000h, 4000h, 2000h, 1000h, 800h, 400h, 200h, 100h  */ /* 8000h is 2 full steps.   100h is 1/64th step.       */
#define MCP_VUNIT                  18 /* Velocity unit size           for axis EPARAM1       */
#define MCP_MAXPOS                 19 /* Maximum position             for axis EPARAM1       */
#define MCP_CURPOS                 20 /* Current position             for axis EPARAM1       */
#define MCP_MAXSPD                 21 /* Maximum speed pu/sec/100     for axis EPARAM1       */
#define MCP_POWER                  22 /* Power settings               for axis EPARAM1       */
/*                           16-bit format: 0000000000000000IIIICCCCRRRRMMMM   */
/*                           32-bit format: IIIIIIIICCCCCCCCRRRRRRRRMMMMMMMM   */
/*                           I=idle C=coasting R=ramping M=manual              */
/*                                                                             */
/*    EPARAM1 values for MCP.UNIT, MCP.MAXPOS, MCP.CURPOS, MCP.POWER:          */
#define MCI_ZAXIS                   0
#define MCI_YAXIS                   1
#define MCI_RAXIS                   2
#define MCI_XAXIS                   3
#define MCI_LAXIS                   4
#define MCI_NMOTORS                 4 /* Z,Y,R,X      */
#define MCI_NAXES                   5 /* Z,Y,R,X,L/C  */
/*                                                                              */
#define MCP_CORAMP                 23 /* Ramp for X/Y moves: MCI.XRAMP, MCI.YRAMP, MCI.ZRAMP */ /*   Set AFTER selecting coordinated axes.            */
#define MCP_XYRAMP                 23 /* The old name                                       */
#define MCP_SETENC                 24 /* Set 32-bit encoder position                        */
#define MCI_ZENC                    0
#define MCI_YENC                    1
#define MCI_RENC                    2
#define MCI_XENC                    3
#define MCI_XWHEEL                  4 /* Train X control wheel  */
#define MCI_YWHEEL                  5 /* Train Y control wheel  */
#define MCI_NENCS                   6
#define MCP_CURRENT                25 /* Write current table.  Obsolete, use MCP.SCURRENT.   */
#define MCP_HBPS                   26 /* Set serial communications rate in 100 bps units     */
#define MCPD_HBPS                 384 /* Default communications rate is 38400 bps            */
/*                                                                               */
#define MCP_OPTIONS                27 /* Set option flags                         */
/*                           Bit0=0 Curve ramp based on faster axis   */
/*                           Bit0=1 Curve ramp based on linear speed  */
/*                           Other bits reserved for future use       */
/*                                                                               */
#define MCP_SHORTSPD               28 /* Fixed speed for short lines for ramp EPARAM1        */
#define MCP_MNLSPD                 29 /* Manual move inter-step-delay                        */
#define MCP_MNLDLY                 30 /* Manual move delay after first step                  */
/* 001F EQU MCP.RESETCHOP  ( Reset chopper breakers.  Obsolete. USE MCP.DRIVER   */
#define MCP_IDLETIME               32 /* # idle packets after motion before IDLE power       */
#define MCP_SETTLES                33 /* Chopper settle times 0-7 in high and low bytes      */
#define MCP_DRIVER                 34 /* Turn driver on/off 0x0m0f m:motor# f:1=on 0=off     */
#define MCP_TRAINRATIO             35 /* Set scale for TRAIN wheel EPARAM1 to param/EPARAM2  */
#define MCP_TRAINSLIP              36 /* Counts per turn for TRAIN wheel EPARAM1             */
#define MCI_YTRAIN                  1
#define MCI_XTRAIN                  2
#define MCP_DEBUG                  37 /* Debug flags                                         */
#define MCP_PULSEDUTY              38 /* Laser power 0-100%                                  */
#define MCP_DACOFFSETS             39 /* Set DAC offsets for motor EPARAM1                   */
#define MCP_DGPERIOD               40 /* Degauss half-cycle period in microseconds           */
#define MCP_DGCYCLES               41 /* Number of degauss half-cycles                       */
#define MCP_DGAMPLITUDE            42 /* Degauss amplitude in 2.14 format                    */
#define MCP_SCURRENT               43 /* Set signed current table entry                      */
#define MCP_AXISFLIP               44 /* 1 to reverse the direction of axis EPARAM1, else 0  */
#define MCP_ENCFLIP                45 /* 1 to reverse the direction of encoder EPARAM1       */
#define MCP_LOCKSTEP               46 /* axis# to phase lock to axis EPARAM1, else -1        */
#define MCP_PHASE                  47 /* Phase shift of current table for axis EPARAM1       */
/*                         ( 0=no shift, 2000h=45 degrees, 4000h=90 degrees.     */
#define MCP_SAVE                   48 /* Save settings to NVRAM                              */
#define MCP_RESTORE                49 /* Restore saved state                                 */
#define MCP_LOCKABORT              50 /* 1 to enable interlock abort else 0                  */
#define MCP_PULSESPACING           51 /* Set #pulses per distance EPARAM1                    */
#define MCP_PULSEENABLE            52 /* Global pulse enable/disable     **VOLATILE**        */
#define MCP_AXISPULSE              53 /* Per-axis enable/disable                             */
#define MCP_LASERCOMP              54 /* Laser power-compensation table entry                */
#define MCP_LASERTICKLE            55 /* Laser tickle width in nanoseconds                   */
#define MCP_GRAYPOWER              56 /* Power lookup table for gray scans                   */
#define MCP_RASTERSHIFT            57 /* For raster alignment                                */
#define MCP_SAVEPARMS              58 /* Save parameters only                                */
#define MCP_RESTOREPARMS           59 /* Restore parameters only                             */
#define MCP_VIEWPOS                60 /* View position for axis EPARAM1 or -1. if none       */
#define MCP_STARTPOS               61 /* Starting position after home for axis EPARAM1       */
#define MCP_HOMESEQ                62 /* Home sequence for axis EPARAM1 or -1. to not home   */
#define MCP_HOMESPEED              63 /* Homing speed for axis EPARAM1                       */
#define MCP_FLAGFLIP               64 /* 1 to invert the home flag for axis EPARAM1          */
#define MCP_OVERTRAVEL             65 /* Homing overtravel for axis EPARAM1                  */
#define MCP_FLAGPOS                66 /* Position of home flag                               */
#define MCP_MINPULSE               67 /* Laser PWM minimum pulse width                       */
#define MCP_TICKLEFREQ             68 /* Tickle frequency in hertz                           */
#define MCP_BOOTFLAGS              69 /* Bit0=1 to enable autoboot.  Write 0 to other bits.  */
#define MCP_QUEUEMSEC              70 /* Set wait threshold for segment queue in millisecs.  */
#define MCP_BACKLASH               71 /* Specify backlash magnitude for axis EPARAM1         */
#define MCP_MUXOUT                 72 /* Set/reset a single multiplexer output               */
#define MCP_MUXSN                  73 /* Set multiplexor serial number  0=not present        */
#define MCP_STEPSIZE               74 /* Set physical step size for axis EPARAM1             */
#define MCP_GREETING               75 /* Set greeting char EPARAM1                           */
#define MCP_PANEL                  76 /* Set LCD panel type for engraver                     */
#define MCPT_PROTOTYPE              0
#define MCPT_ONLINE                 1
#define MCPT_BDE                    2
#define MCP_TRIGMSEC               77 /* Minimum valid trigger width in milliseconds 0-300   */
#define MCP_INDEXABORT             78 /* Per-axis enable/disable INDEX on-transition abort   */
#define MCP_INDEXFLIP              79 /* Invert INDEX abort polarity for axis EPARAM1        */
#define MCP_FLAGWIDTH              80 /* Maximum travel across homing flag                   */
#define MCP_PENDELAY               81 /* Pen-down to motion-start delay milliseconds         */
#define MCP_CPMAXSPD               82 /* CRAMP max speed                                     */
#define MCP_CPRAMP                 83 /* Select cpath ramp: MCI.xRAMP                        */
#define MCP_IOPANTRIM              84 /* IOPAN LCD contrast, millivolts                      */
#define MCTT_TRIM_20C               0 /* Index in high word                                  */
#define MCTT_TRIM25C                1
#define MCTT_TRIM70C                2
#define MCP_REFSPEEDXY             85
#define MCP_REFSPEEDZ              86
#define MCP_JOGSPEED               87
#define MCP_CPVUNIT                88 /* Set CVUNIT.  Doesn't cause old versions to malf.    */
#define MCP_STEP_DIR               89 /* -1 to change axis EPARAM1 from CHOP to step, dir.   */
#define MCP_OPMODE                 90 /* Default application operation mode                  */
#define MCOM_LASER                  1 /*     Laser engraver                                  */
#define MCOM_MECHANICAL             2 /*     Mechanical engraver                             */
#define MCP_BACKLASHCOMP           91 /* Global enable/disable     **VOLATILE**              */
#define MCP_LOWPOWER               92 /* Use low-current reference in chopper                */
#define MCP_PENOE                  93 /* -1 to enable hardware pen on SENSE out else 0       */
#define MCP_INDEXSTOP              94 /* MCIFS code for index action                         */
#define MCP_FLAGSTOP               95 /* MCIFS code for flag action                          */
#define MCIFS_NONE                  0 /* No stop at min or max                               */
#define MCIFS_PLUS                  1 /* Disable positive motion when input seen             */
#define MCIFS_MINUS                 2 /* Disable negative motion when input seen             */
#define MCP_ENABLE                 96 /* Axis enable for engraver                            */
#define MCP_RESERVED               97 /* An illegal parameter index                          */
#define MCP_MCPMAX                 97 /* The last parameter index                            */
/*                                                                               */

/* End USTEPCMD.H generated from USTEPCMD.4TH */
