// mcapi.h

// These are high-level functions using physical units.
// Only part of the RSTEP functionality is available.
// Positions are expressed in units of 1/10000 inch.

#ifdef _EXPORTING_MCAPI
#define MCAPI extern __declspec(dllexport)
#else
#define MCAPI extern __declspec(dllimport)
#endif
#define MCCALL __stdcall

// Mcc_Init() return values
#define MCIERR_OK                     0 // No error
#define MCIERR_GENERIC                1 // Non-specific error
#define MCIERR_NO_PERFORMANCE_COUNTER 2
#define MCIERR_CANT_READ_CONFIG       3
#define MCIERR_BAD_CONFIG             4
#define MCIERR_CANT_READ_MPM          5
#define MCIERR_BAD_MPM                6
#define MCIERR_CANT_OPEN_COM          7
#define MCIERR_BOX_DEAD               8
#define MCIERR_CANT_SYNC              9
#define MCIERR_WRONG_MPM_VERSION     10
#define MCIERR_BAD_MOTION_PARAMS     11

// Non-Mcc_Init return values
#define MCXERR_OK                     0 // No error
#define MCXERR_GENERIC                1 // Non-specific error
#define MCXERR_NOT_INITTED           10 // Not initialized

MCAPI int MCCALL Mcc_GetApiVersion(int *piMajor, int *piMinor);

MCAPI int MCCALL Mcc_Init(void);             // COM port in main.cfg
MCAPI int MCCALL Mcc_InitOnCom(int iPort);   // COM port in param

MCAPI int MCCALL Mcc_Finish(void);           // Release the COM port
MCAPI int MCCALL Mcc_SetWaitMode(int iMode);
#define MCSWM_WAIT_LATE  0
#define MCSWM_WAIT_EARLY 1

MCAPI int MCCALL Mcc_SetDebugMask(int iMask);
#define MCSDM_DEBUG_MCC      1
#define MCSDM_DEBUG_RSTEP    2
#define MCSDM_DEBUG_COMMANDS 4

MCAPI int MCCALL Mcc_2dMode(void);  // 3rd axis is Laser, if enabled
MCAPI int MCCALL Mcc_3dMode(void);  // 3rd axis is Z

MCAPI int MCCALL Mcc_PenUp(void);   // No pulsing, fast speed
MCAPI int MCCALL Mcc_PenDown(void); // Use specified velocity

MCAPI int MCCALL Mcc_Home(void);


MCAPI int MCCALL Mcc_JogBeginX(void);
MCAPI int MCCALL Mcc_JogBeginY(void);
MCAPI int MCCALL Mcc_JogBeginZ(void);
MCAPI int MCCALL Mcc_JogBeginR(void);
MCAPI int MCCALL Mcc_JogSetPosition(long lPos);
MCAPI int MCCALL Mcc_JogEnd(void);

// Mcc_MoveXY() and Mcc_MoveXYZ() return before motion is finished
MCAPI int MCCALL Mcc_MoveXY(long x, long y);         // Coordinated 2D move
MCAPI int MCCALL Mcc_MoveXYZ(long x,long y, long z); // Coordinated 3D move

MCAPI int MCCALL Mcc_MoveZ(long z);        // Does not return until motion is done
MCAPI int MCCALL Mcc_MoveR(long r);
MCAPI int MCCALL Mcc_InMotion(void);       // Check motion status during coordinated moves
MCAPI int MCCALL Mcc_TestCall(int iParam); // Returns its parameter for testing

MCAPI int MCCALL Mcc_Velocity(int iInchesPerMinute);

MCAPI int MCCALL Mcc_SetSampleSpacing(long lPulses, long lTenthMils);
#define MCSS_MAX_PULSES (0xFFFF)

MCAPI int MCCALL Mcc_LaserOn(int iEnable);   // Enable/disable pulse output

MCAPI int MCCALL Mcc_GetRtPos(long *lX, long *lY, long *lZ);
MCAPI int MCCALL Mcc_GetMachinePosition(long *lX, long *lY, long *lZ);

MCAPI int MCCALL Mcc_GetRotorPosition(long *lR);

MCAPI const char *MCCALL Mcc_GetErrorString(void);

MCAPI void MCCALL Mcc_DumbTerminal(int iPort);
