// RSAPI.h

// Low-level RSTEP functions

#ifdef _EXPORTING_RSAPI
#define RSAPI __declspec(dllexport)
#else
#define RSAPI __declspec(dllimport)
#endif
#define RSCALL __stdcall

#define MCAM_TIMEOUT (0x100)

#define MCST_HALTED    0
#define MCST_RUNNING   1
#define MCST_ESTOP     2
#define MCST_LOCKABORT 2

#define BOX_UP     0
#define BOX_BOOT   1
#define BOX_REBOOT 2
#define BOX_DEAD   3

#define RSDM_DEBUG_RSTEP    2
#define RSDM_DEBUG_COMMANDS 4

// Buffer for RstepGetSavedID(), RstepGetParmID()
#define RS_ID_BUF_BYTES 13

RSAPI int  RSCALL RstepEstop(void);
RSAPI int  RSCALL RstepGetBoxState(void);
RSAPI long RSCALL RstepGetInfo(int iIndex, int iSubindex);
RSAPI int  RSCALL RstepGetSavedID(char *pcBuf);
RSAPI int  RSCALL RstepGetState(void);
RSAPI int  RSCALL RstepHome(int iMask);
RSAPI int  RSCALL RstepHome1(int iAxis, BOOL bFlagPolarity, long lOvertravel, long lHomePos);
RSAPI BOOL RSCALL RstepHomed(void);
RSAPI BOOL RSCALL RstepInMotion(void);
RSAPI int  RSCALL RstepInstall(int iPort);
RSAPI int  RSCALL RstepIsInstalled(void);
RSAPI int  RSCALL RstepMakeRamps(void);
RSAPI BOOL RSCALL RstepMakeRampsWorked(void);
RSAPI int  RSCALL RstepParam(int iIndex,long lVal);
RSAPI int  RSCALL RstepPenDown(void);
RSAPI int  RSCALL RstepPenDownNow(void);
RSAPI int  RSCALL RstepPenUpNow(void);
RSAPI int  RSCALL RstepRemove(void);
RSAPI int  RSCALL RstepSelectY(int iAxis);
RSAPI int  RSCALL RstepSelectXY(int iX, int iY);
RSAPI int  RSCALL RstepSelectXYZ(int iX, int iY, int iZ);
RSAPI int  RSCALL RstepSetDebugMask(int iMode);
RSAPI int  RSCALL RstepSetEncoder(int iIndex, long lCount);
RSAPI int  RSCALL RstepSetMinPulse(int iNanoseconds);
RSAPI int  RSCALL RstepSetPulseDuty(int iPercent);
RSAPI int  RSCALL RstepSetPulseEnable(BOOL bEnable);
RSAPI int  RSCALL RstepSetPulseSpacing(long lPulses, long lTravel);
RSAPI int  RSCALL RstepSetTimeout(int iSeconds);
RSAPI int  RSCALL RstepSetTrainRatio(int iIndex, int iCounts, int iSteps);
RSAPI int  RSCALL RstepSetWaitMode(int iMode);
RSAPI int  RSCALL RstepSync(BOOL bBoot);
RSAPI int  RSCALL RstepSpeed(int iSpeed);
RSAPI int  RSCALL Rstep1Speed(int iAxis, int iSpeed);
RSAPI int  RSCALL RstepTestMode(BOOL bOn);
RSAPI int  RSCALL RstepTrainBegin(void);
RSAPI int  RSCALL RstepTrainEnd(void);
RSAPI int  RSCALL RstepVector(BOOL bCpath);
RSAPI int  RSCALL RstepWaitHalt(void);
RSAPI int  RSCALL RstepXrel(long x);
RSAPI int  RSCALL RstepYrel(long y);
RSAPI int  RSCALL RstepXabs(long x);
RSAPI int  RSCALL RstepYabs(long y);
RSAPI int  RSCALL Rstep1abs(int iAxis, long l);
RSAPI int  RSCALL Rstep1rel(int iAxis, long l);
RSAPI int  RSCALL RstepXYrel(long x, long y);
RSAPI int  RSCALL RstepXYZrel(long x, long y, long z);
RSAPI int  RSCALL RstepXYabs(long x, long y);
RSAPI int  RSCALL RstepXYZabs(long x, long y, long z);
